# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_kanidm_global_optspecs
	string join \n h/help
end

function __fish_kanidm_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_kanidm_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_kanidm_using_subcommand
	set -l cmd (__fish_kanidm_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c kanidm -n "__fish_kanidm_needs_command" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "login" -d 'Login to an account to use with future cli operations'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "reauth" -d 'Reauthenticate to access privileged functions of this account for a short period'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "logout" -d 'Logout of an active cli session'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "session" -d 'Manage active cli sessions'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "self" -d 'Actions for the current authenticated account'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "person" -d 'Actions to manage and view person (user) accounts'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "group" -d 'Actions to manage groups'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "service-account" -d 'Actions to manage and view service accounts'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "graph" -d 'Prints graphviz dot file of all groups'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "schema" -d 'Schema management operations'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "system" -d 'System configuration operations'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "recycle-bin" -d 'Recycle Bin operations'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "raw" -d 'Unsafe - low level, raw database queries and operations'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "version" -d 'Print the program version and exit'
complete -c kanidm -n "__fish_kanidm_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s p -l password -d 'Supply a password to the login option' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand login" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand reauth" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s l -l local-only -d 'Do not send a logout request to the server - only remove the session token locally'
complete -c kanidm -n "__fish_kanidm_using_subcommand logout" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and not __fish_seen_subcommand_from list cleanup help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and not __fish_seen_subcommand_from list cleanup help" -f -a "list" -d 'List current active sessions'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and not __fish_seen_subcommand_from list cleanup help" -f -a "cleanup" -d 'Remove sessions that have expired or are invalid'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and not __fish_seen_subcommand_from list cleanup help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from cleanup" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from help" -f -a "list" -d 'List current active sessions'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from help" -f -a "cleanup" -d 'Remove sessions that have expired or are invalid'
complete -c kanidm -n "__fish_kanidm_using_subcommand session; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and not __fish_seen_subcommand_from identify-user whoami help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and not __fish_seen_subcommand_from identify-user whoami help" -f -a "identify-user" -d 'Use the identify user feature'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and not __fish_seen_subcommand_from identify-user whoami help" -f -a "whoami" -d 'Show the current authenticated user\'s identity'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and not __fish_seen_subcommand_from identify-user whoami help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from identify-user" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from whoami" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "identify-user" -d 'Use the identify user feature'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "whoami" -d 'Show the current authenticated user\'s identity'
complete -c kanidm -n "__fish_kanidm_using_subcommand self; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "credential" -d 'Manage the credentials this person uses for authentication'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "radius" -d 'Manage radius access for this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "posix" -d 'Manage posix extensions for this person allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "list" -d 'List all persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "get" -d 'View a specific person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "search" -d 'Search persons by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "update" -d 'Update a specific person\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "create" -d 'Create a new person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "delete" -d 'Delete a person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "validity" -d 'Manage a person\'s account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "certificate"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and not __fish_seen_subcommand_from credential radius posix session ssh list get search update create delete validity certificate help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -f -a "status" -d 'Show the status of this accounts credentials'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -f -a "update" -d 'Interactively update/change the credentials for an account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -f -a "use-reset-token" -d 'Using a reset token, interactively reset credentials for a user'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -f -a "create-reset-token" -d 'Create a reset token that can be given to another person so they can recover or reset their account credentials'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from credential" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from radius" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from radius" -f -a "show-secret" -d 'Show the RADIUS secret for a user'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from radius" -f -a "generate-secret" -d 'Generate a randomized RADIUS secret for a user'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from radius" -f -a "delete-secret" -d 'Remove the configured RADIUS secret for the user'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from radius" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -f -a "show"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -f -a "set"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -f -a "set-password"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -f -a "reset-gidnumber" -d 'Reset the gidnumber of this person to the generated default'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from posix" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from session" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from session" -f -a "status" -d 'Show the status of logged in sessions associated to this account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from session" -f -a "destroy" -d 'Destroy / revoke a session for this account. Access to the session (user auth token) is NOT required, only the uuid of the session'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from session" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from ssh" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from ssh" -f -a "list-publickeys"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from ssh" -f -a "add-publickey"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from ssh" -f -a "delete-publickey"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from ssh" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s l -l legalname -d 'Set the legal name for the person.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s n -l newname -d 'Set the account name for the person.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s i -l displayname -d 'Set the display name for the person.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s m -l mail -d 'Set the mail address, can be set multiple times for multiple addresses. The first listed mail address is the \'primary\'' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from validity" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from validity" -f -a "show" -d 'Show an accounts validity window'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from validity" -f -a "expire-at" -d 'Set an accounts expiry time'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from validity" -f -a "begin-from" -d 'Set an account valid from time'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from validity" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from certificate" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from certificate" -f -a "status"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from certificate" -f -a "create"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from certificate" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "credential" -d 'Manage the credentials this person uses for authentication'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "radius" -d 'Manage radius access for this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "posix" -d 'Manage posix extensions for this person allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "get" -d 'View a specific person'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "search" -d 'Search persons by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "update" -d 'Update a specific person\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "validity" -d 'Manage a person\'s account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "certificate"
complete -c kanidm -n "__fish_kanidm_using_subcommand person; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "list" -d 'List all groups'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "get" -d 'View a specific group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "search" -d 'Search a group by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "create" -d 'Create a new group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "delete" -d 'Delete a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "list-members" -d 'List the members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "set-members" -d 'Set the exact list of members that this group should contain, removing any not listed in the set operation'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "set-mail" -d 'Set the exact list of mail addresses that this group is associated with. The first mail address in the list is the `primary` and the remainder are aliases. Setting an empty list will clear the mail attribute'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "set-description" -d 'Set the description of this group. If no description is provided, the value is cleared'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "set-entry-manager" -d 'Set a new entry-managed-by for this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "rename" -d 'Rename an existing group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "purge-members" -d 'Delete all members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "add-members" -d 'Add new members to a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "remove-members" -d 'Remove the named members from this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "posix" -d 'Manage posix extensions for this group allowing groups to be used on unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "account-policy" -d 'Manage the policies that apply to members of this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and not __fish_seen_subcommand_from list get search create delete list-members set-members set-mail set-description set-entry-manager rename purge-members add-members remove-members posix account-policy help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from list-members" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-members" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-mail" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-description" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from set-entry-manager" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from rename" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from purge-members" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from add-members" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from remove-members" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from posix" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from posix" -f -a "show" -d 'Show details of a specific posix group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from posix" -f -a "set" -d 'Setup posix group properties, or alter them'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from posix" -f -a "reset-gidnumber" -d 'Reset the gidnumber of this group to the generated default'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from posix" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "enable" -d 'Enable account policy for this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "auth-expiry" -d 'Set the maximum time for session expiry in seconds'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "credential-type-minimum" -d 'Set the minimum credential class that members may authenticate with. Valid values in order of weakest to strongest are: "any" "mfa" "passkey" "attested_passkey"'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "password-minimum-length" -d 'Set the minimum character length of passwords for accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "privilege-expiry" -d 'Set the maximum time for privilege session expiry in seconds'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "webauthn-attestation-ca-list" -d 'The WebAuthn attestation CA list that should be enforced on members of this group. Prevents use of passkeys that are not in this list. To create this list, use `fido-mds-tool` from <https://crates.io/crates/fido-mds-tool>'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "limit-search-max-results" -d 'Sets the maximum number of entries that may be returned in a search operation'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "limit-search-max-filter-test" -d 'Sets the maximum number of entries that are examined during a partially indexed search. This does not affect fully indexed searches. If in doubt, set this to 1.5x limit-search-max-results'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "allow-primary-cred-fallback" -d 'Sets whether during login the primary password can be used as a fallback if no posix password has been defined'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-auth-expiry" -d 'Reset the maximum time for session expiry to its default value'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-password-minimum-length" -d 'Reset the minimum character length of passwords to its default value'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-privilege-expiry" -d 'Reset the maximum time for privilege session expiry to its default value'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-webauthn-attestation-ca-list" -d 'Reset the WebAuthn attestation CA list to its default value allowing any passkey to be used by members of this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-limit-search-max-results" -d 'Reset the searche maxmium results limit to its default value'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "reset-limit-search-max-filter-test" -d 'Reset the max filter test limit to its default value'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from account-policy" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all groups'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "get" -d 'View a specific group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "search" -d 'Search a group by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "list-members" -d 'List the members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "set-members" -d 'Set the exact list of members that this group should contain, removing any not listed in the set operation'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "set-mail" -d 'Set the exact list of mail addresses that this group is associated with. The first mail address in the list is the `primary` and the remainder are aliases. Setting an empty list will clear the mail attribute'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "set-description" -d 'Set the description of this group. If no description is provided, the value is cleared'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "set-entry-manager" -d 'Set a new entry-managed-by for this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "rename" -d 'Rename an existing group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "purge-members" -d 'Delete all members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "add-members" -d 'Add new members to a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "remove-members" -d 'Remove the named members from this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "posix" -d 'Manage posix extensions for this group allowing groups to be used on unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "account-policy" -d 'Manage the policies that apply to members of this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand group; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "credential" -d 'Manage the generated password of this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "api-token" -d 'Manage api tokens associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "posix" -d 'Manage posix extensions for this service account allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "list" -d 'List all service accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "get" -d 'View a specific service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "create" -d 'Create a new service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "update" -d 'Update a specific service account\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "delete" -d 'Delete a service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "validity" -d 'Manage a service account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "into-person" -d '(Deprecated - due for removal in v1.1.0-15) - Convert a service account into a person. This is used during the alpha.9 to alpha.10 migration to "fix up" accounts that were not previously marked as persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and not __fish_seen_subcommand_from credential api-token posix session ssh list get create update delete validity into-person help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from credential" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from credential" -f -a "status" -d 'Show the status of this accounts password'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from credential" -f -a "generate" -d 'Reset and generate a new service account password. This password can NOT be used with the LDAP interface'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from credential" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from api-token" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from api-token" -f -a "status" -d 'Show the status of api tokens associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from api-token" -f -a "generate" -d 'Generate a new api token for this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from api-token" -f -a "destroy" -d 'Destroy / revoke an api token from this service account. Access to the token is NOT required, only the tag/uuid of the token'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from api-token" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from posix" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from posix" -f -a "show"
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from posix" -f -a "set"
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from posix" -f -a "reset-gidnumber" -d 'Reset the gidnumber of this service account to the generated default'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from posix" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from session" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from session" -f -a "status" -d 'Show the status of logged in sessions associated to this account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from session" -f -a "destroy" -d 'Destroy / revoke a session for this account. Access to the session (user auth token) is NOT required, only the uuid of the session'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from session" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from ssh" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from ssh" -f -a "list-publickeys"
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from ssh" -f -a "add-publickey"
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from ssh" -f -a "delete-publickey"
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from ssh" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s n -l newname -d 'Set the account name for the service account.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s i -l displayname -d 'Set the display name for the service account.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s e -l entry-managed-by -d 'Set the entry manager for the service account.' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s m -l mail -d 'Set the mail address, can be set multiple times for multiple addresses. The first listed mail address is the \'primary\'' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from validity" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from validity" -f -a "show" -d 'Show an accounts validity window'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from validity" -f -a "expire-at" -d 'Set an accounts expiry time'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from validity" -f -a "begin-from" -d 'Set an account valid from time'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from validity" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from into-person" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "credential" -d 'Manage the generated password of this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "api-token" -d 'Manage api tokens associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "posix" -d 'Manage posix extensions for this service account allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all service accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "get" -d 'View a specific service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "update" -d 'Update a specific service account\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "validity" -d 'Manage a service account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "into-person" -d '(Deprecated - due for removal in v1.1.0-15) - Convert a service account into a person. This is used during the alpha.9 to alpha.10 migration to "fix up" accounts that were not previously marked as persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand service-account; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand graph" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and not __fish_seen_subcommand_from class attribute attr help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and not __fish_seen_subcommand_from class attribute attr help" -f -a "class" -d 'Class related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and not __fish_seen_subcommand_from class attribute attr help" -f -a "attribute" -d 'Attribute related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and not __fish_seen_subcommand_from class attribute attr help" -f -a "attr" -d 'Attribute related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and not __fish_seen_subcommand_from class attribute attr help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from class" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from class" -f -a "list" -d 'List all classes'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from class" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from class" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attribute" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attribute" -f -a "list" -d 'List all attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attribute" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attribute" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attr" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attr" -f -a "list" -d 'List all attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attr" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from attr" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from help" -f -a "class" -d 'Class related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from help" -f -a "attribute" -d 'Attribute related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand schema; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "pw-badlist" -d 'Configure and manage the password badlist entry'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "denied-names" -d 'Configure and manage denied names'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "oauth2" -d 'Configure and display oauth2/oidc client configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "domain" -d 'Configure and display domain configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "sync" -d 'Configure synchronisation from an external IDM system'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "api" -d 'API related things'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and not __fish_seen_subcommand_from pw-badlist denied-names oauth2 domain sync api help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from pw-badlist" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from pw-badlist" -f -a "show" -d 'Show information about this system\'s password badlist'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from pw-badlist" -f -a "upload" -d 'Upload an extra badlist, appending to the currently configured one. This badlist will be preprocessed to remove items that are already caught by "zxcvbn" at the configured level'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from pw-badlist" -f -a "remove" -d 'Remove the content of these lists if present in the configured badlist'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from pw-badlist" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from denied-names" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from denied-names" -f -a "show" -d 'Show information about this system\'s denied name list'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from denied-names" -f -a "append"
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from denied-names" -f -a "remove" -d 'Remove a name from the denied name list'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from denied-names" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "list" -d 'List all configured oauth2 clients'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "get" -d 'Display a selected oauth2 client'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "create" -d 'Create a new oauth2 confidential client that is protected by basic auth'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "create-public" -d 'Create a new OAuth2 public client that requires PKCE. You should prefer using confidential client types if possible over public ones'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "update-scope-map" -d 'Update or add a new mapping from a group to scopes that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "create-scope-map" -d 'Update or add a new mapping from a group to scopes that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "delete-scope-map" -d 'Remove a mapping from groups to scopes'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "update-sup-scope-map" -d 'Update or add a new mapping from a group to scopes that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "create-sup-scope-map" -d 'Update or add a new mapping from a group to scopes that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "delete-sup-scope-map" -d 'Remove a mapping from groups to scopes'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "update-claim-map" -d 'Update or add a new mapping from a group to custom claims that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "create-claim-map" -d 'Update or add a new mapping from a group to custom claims that it provides to members'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "update-claim-map-join"
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "delete-claim-map" -d 'Remove a mapping from groups to a custom claim'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "reset-basic-secret" -d 'Reset the client basic secret. You will need to update your client after executing this'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "show-basic-secret" -d 'Show the associated basic secret for this client'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "delete" -d 'Delete a oauth2 client'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "set-displayname" -d 'Set a new display name for a client'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "set-name" -d 'Set a new name for this client. You will need to update your integrated applications after this so that they continue to function correctly'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "set-landing-url" -d 'The landing URL is the default origin of the OAuth2 client. Additionally, this landing URL is the target when Kanidm redirects the user from the apps listing page'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "set-image" -d 'The image presented on the Kanidm Apps Listing page for an OAuth2 resource server'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "remove-image" -d 'Removes the custom image previously set'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "add-redirect-url" -d 'Add a supplemental URL as a redirection target. For example a phone app may use a redirect URL such as `app://my-cool-app` to trigger a native redirection event out of a browser'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "remove-redirect-url" -d 'Remove a supplemental redirect URL from the OAuth2 client configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "enable-pkce" -d 'Enable PKCE on this oauth2 client. This defaults to being enabled'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "warning-insecure-client-disable-pkce" -d 'Disable PKCE on this oauth2 client to work around insecure clients that may not support it. You should request the client to enable PKCE!'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "warning-enable-legacy-crypto" -d 'Enable legacy signing crypto on this oauth2 client. This defaults to being disabled. You only need to enable this for openid clients that do not support modern cryptographic operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "disable-legacy-crypto" -d 'Disable legacy signing crypto on this oauth2 client. This is the default'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "enable-strict-redirect-url" -d 'Enable strict validation of redirect URLs. Previously redirect URLs only validated the origin of the URL matched. When enabled, redirect URLs must match exactly'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "disable-strict-redirect-url"
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "enable-localhost-redirects" -d 'Allow public clients to redirect to localhost'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "disable-localhost-redirects" -d 'Disable public clients redirecting to localhost'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "prefer-short-username" -d 'Use the \'name\' attribute instead of \'spn\' for the preferred_username'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "prefer-spn-username" -d 'Use the \'spn\' attribute instead of \'name\' for the preferred_username'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "rotate-cryptographic-keys" -d 'Rotate the signing and encryption keys used by this client. The rotation will occur at the specified time of the format "YYYY-MM-DDTHH:MM:SS+TZ", "2020-09-25T11:22:02+10:00" or immediately if the time is set to the value "now". Past signatures will continue to operate even after a rotation occurs. If you have concerns a key is compromised, then you should revoke it instead'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "revoke-cryptographic-key" -d 'Revoke the signing and encryption keys used by this client. This will immediately trigger a rotation of the key in question, and signtatures or tokens issued by the revoked key will not be considered valid'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from oauth2" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-displayname" -d 'Set the domain display name'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-ldap-queryable-attrs" -d 'Sets the maximum number of LDAP attributes that can be queried in one operation'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-ldap-basedn" -d 'Change the basedn of this server. Takes effect after a server restart. Examples are `o=organisation` or `dc=domain,dc=name`. Must be a valid ldap dn containing only alphanumerics, and dn components must be org (o), domain (dc) or orgunit (ou)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-ldap-allow-unix-password-bind" -d 'Enable or disable unix passwords being used to bind via LDAP. Unless you have a specific requirement for this, you should disable this'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-allow-easter-eggs" -d 'Enable or disable easter eggs in the server. This includes seasonal icons, kanidm birthday surprises and other fun components. Defaults to false for production releases and true in development builds'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "show" -d 'Show information about this system\'s domain'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "revoke-key" -d 'Revoke a key by its key id. This will cause all user sessions to be invalidated (logged out)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "set-image" -d 'The image presented as the instance logo'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "remove-image" -d 'The remove the current instance logo, reverting to the default'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from domain" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "list" -d 'List all configured IDM sync accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "get" -d 'Display a selected IDM sync account'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "set-credential-portal" -d 'Set the url to the external credential portal. This will be displayed to synced users so that they can be redirected to update their credentials on this portal'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "create" -d 'Create a new IDM sync account'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "generate-token" -d 'Generate a bearer token for an IDM sync account'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "destroy-token" -d 'Destroy (revoke) the bearer token for an IDM sync account'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "set-yield-attributes" -d 'Set the list of attributes that have their authority yielded from the sync account and are allowed to be modified by kanidm and users. Any attributes not listed in in this command will have their authority returned to the sync account'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "force-refresh" -d 'Reset the sync cookie of this connector, so that on the next operation of the sync tool a full refresh of the provider is requested. Kanidm attributes that have been granted authority will *not* be lost or deleted'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "finalise" -d 'Finalise and remove this sync account. This will transfer all synchronised entries into the authority of Kanidm. This signals the end of a migration from an external IDM into Kanidm. ⚠️  This action can NOT be undone. Once complete, it is most likely that attempting to recreate a sync account from the same IDM will fail due to conflicting entries that Kanidm now owns'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "terminate" -d 'Terminate and remove this sync account. This will DELETE all entries that were imported from the external IDM source. ⚠️  This action can NOT be undone, and will require you to recreate the sync account if you wish to re-import data. Recreating the sync account may fail until the recycle bin and and tombstones are purged'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from sync" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from api" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from api" -f -a "download-schema" -d 'Download the OpenAPI schema file'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from api" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "pw-badlist" -d 'Configure and manage the password badlist entry'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "denied-names" -d 'Configure and manage denied names'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "oauth2" -d 'Configure and display oauth2/oidc client configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "domain" -d 'Configure and display domain configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "sync" -d 'Configure synchronisation from an external IDM system'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "api" -d 'API related things'
complete -c kanidm -n "__fish_kanidm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and not __fish_seen_subcommand_from list get revive help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and not __fish_seen_subcommand_from list get revive help" -f -a "list" -d 'List objects that are in the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and not __fish_seen_subcommand_from list get revive help" -f -a "get" -d 'Display an object from the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and not __fish_seen_subcommand_from list get revive help" -f -a "revive" -d 'Revive a recycled object into a live (accessible) state - this is the opposite of "delete"'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and not __fish_seen_subcommand_from list get revive help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from revive" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from help" -f -a "list" -d 'List objects that are in the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from help" -f -a "get" -d 'Display an object from the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from help" -f -a "revive" -d 'Revive a recycled object into a live (accessible) state - this is the opposite of "delete"'
complete -c kanidm -n "__fish_kanidm_using_subcommand recycle-bin; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -f -a "create"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -f -a "modify"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -f -a "delete"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and not __fish_seen_subcommand_from search create modify delete help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from modify" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s I -l instance -d 'Select the instance name you wish to connect to' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s H -l url -d 'The URL of the kanidm instance' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s D -l name -d 'User which will initiate requests' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s C -l ca -d 'Path to a CA certificate file' -r -F
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s t -l token-cache-path -d 'Path to a file to cache tokens in, defaults to ~/.cache/kanidm_tokens' -r
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s d -l debug -d 'Enable debugging of the kanidm tool'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -l skip-hostname-verification -d 'Skip hostname verification'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -l accept-invalid-certs -d 'Don\'t verify CA'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from help" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from help" -f -a "create"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from help" -f -a "modify"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from help" -f -a "delete"
complete -c kanidm -n "__fish_kanidm_using_subcommand raw; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand version" -s h -l help -d 'Print help'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "login" -d 'Login to an account to use with future cli operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "reauth" -d 'Reauthenticate to access privileged functions of this account for a short period'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "logout" -d 'Logout of an active cli session'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "session" -d 'Manage active cli sessions'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "self" -d 'Actions for the current authenticated account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "person" -d 'Actions to manage and view person (user) accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "group" -d 'Actions to manage groups'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "service-account" -d 'Actions to manage and view service accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "graph" -d 'Prints graphviz dot file of all groups'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "schema" -d 'Schema management operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "system" -d 'System configuration operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "recycle-bin" -d 'Recycle Bin operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "raw" -d 'Unsafe - low level, raw database queries and operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "version" -d 'Print the program version and exit'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and not __fish_seen_subcommand_from login reauth logout session self person group service-account graph schema system recycle-bin raw version help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from session" -f -a "list" -d 'List current active sessions'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from session" -f -a "cleanup" -d 'Remove sessions that have expired or are invalid'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from self" -f -a "identify-user" -d 'Use the identify user feature'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from self" -f -a "whoami" -d 'Show the current authenticated user\'s identity'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "credential" -d 'Manage the credentials this person uses for authentication'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "radius" -d 'Manage radius access for this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "posix" -d 'Manage posix extensions for this person allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "list" -d 'List all persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "get" -d 'View a specific person'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "search" -d 'Search persons by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "update" -d 'Update a specific person\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "create" -d 'Create a new person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "delete" -d 'Delete a person\'s account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "validity" -d 'Manage a person\'s account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from person" -f -a "certificate"
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "list" -d 'List all groups'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "get" -d 'View a specific group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "search" -d 'Search a group by name'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "create" -d 'Create a new group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "delete" -d 'Delete a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "list-members" -d 'List the members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "set-members" -d 'Set the exact list of members that this group should contain, removing any not listed in the set operation'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "set-mail" -d 'Set the exact list of mail addresses that this group is associated with. The first mail address in the list is the `primary` and the remainder are aliases. Setting an empty list will clear the mail attribute'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "set-description" -d 'Set the description of this group. If no description is provided, the value is cleared'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "set-entry-manager" -d 'Set a new entry-managed-by for this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "rename" -d 'Rename an existing group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "purge-members" -d 'Delete all members of a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "add-members" -d 'Add new members to a group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "remove-members" -d 'Remove the named members from this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "posix" -d 'Manage posix extensions for this group allowing groups to be used on unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from group" -f -a "account-policy" -d 'Manage the policies that apply to members of this group'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "credential" -d 'Manage the generated password of this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "api-token" -d 'Manage api tokens associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "posix" -d 'Manage posix extensions for this service account allowing access to unix/linux systems'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "session" -d 'Manage sessions (user auth tokens) associated to this service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "ssh" -d 'Manage ssh public key\'s associated to this person'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "list" -d 'List all service accounts'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "get" -d 'View a specific service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "create" -d 'Create a new service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "update" -d 'Update a specific service account\'s attributes'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "delete" -d 'Delete a service account'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "validity" -d 'Manage a service account validity, such as expiry time (account lock/unlock)'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from service-account" -f -a "into-person" -d '(Deprecated - due for removal in v1.1.0-15) - Convert a service account into a person. This is used during the alpha.9 to alpha.10 migration to "fix up" accounts that were not previously marked as persons'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from schema" -f -a "class" -d 'Class related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from schema" -f -a "attribute" -d 'Attribute related operations'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "pw-badlist" -d 'Configure and manage the password badlist entry'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "denied-names" -d 'Configure and manage denied names'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "oauth2" -d 'Configure and display oauth2/oidc client configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "domain" -d 'Configure and display domain configuration'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "sync" -d 'Configure synchronisation from an external IDM system'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "api" -d 'API related things'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from recycle-bin" -f -a "list" -d 'List objects that are in the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from recycle-bin" -f -a "get" -d 'Display an object from the recycle bin'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from recycle-bin" -f -a "revive" -d 'Revive a recycled object into a live (accessible) state - this is the opposite of "delete"'
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from raw" -f -a "search"
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from raw" -f -a "create"
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from raw" -f -a "modify"
complete -c kanidm -n "__fish_kanidm_using_subcommand help; and __fish_seen_subcommand_from raw" -f -a "delete"
