# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_kanidmd_global_optspecs
	string join \n h/help
end

function __fish_kanidmd_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_kanidmd_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_kanidmd_using_subcommand
	set -l cmd (__fish_kanidmd_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c kanidmd -n "__fish_kanidmd_needs_command" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "server" -d 'Start the IDM Server'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "configtest" -d 'Test the IDM Server configuration, without starting network listeners'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "cert-generate" -d 'Create a self-signed ca and tls certificate in the locations listed from the configuration. These certificates should *not* be used in production, they are for testing and evaluation only!'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "recover-account" -d 'Recover an account\'s password'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "disable-account" -d 'Disable an account so that it can not be used. This can be reset with `recover-account`'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "show-replication-certificate" -d 'Display this server\'s replication certificate'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "renew-replication-certificate" -d 'Renew this server\'s replication certificate'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "refresh-replication-consumer" -d 'Refresh this servers database content with the content from a supplier. This means that all local content will be deleted and replaced with the supplier content'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "db-scan" -d 'Inspect the internal content of the database datastructures'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "database" -d 'Database maintenance, backups, restoration etc'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "domain" -d 'Change domain settings'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "healthcheck" -d 'Load the server config and check services are listening'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "version" -d 'Print the program version and exit'
complete -c kanidmd -n "__fish_kanidmd_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand server" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand server" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand server" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand configtest" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand configtest" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand configtest" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand cert-generate" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand cert-generate" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand cert-generate" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand recover-account" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand recover-account" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand recover-account" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand disable-account" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand disable-account" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand disable-account" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand show-replication-certificate" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand show-replication-certificate" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand show-replication-certificate" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand renew-replication-certificate" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand renew-replication-certificate" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand renew-replication-certificate" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand refresh-replication-consumer" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand refresh-replication-consumer" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand refresh-replication-consumer" -l i-want-to-refresh-this-servers-database -d 'Acknowledge that this database content will be refreshed from a supplier'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand refresh-replication-consumer" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "list-all-indexes" -d 'List all index tables that exist on the system'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "list-index" -d 'List all content of a named index'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "list-id2entry" -d 'List all id2entry values with reduced entry content'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "get-id2entry" -d 'View the data of a specific entry from id2entry'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "list-index-analysis" -d 'List all content of index analysis'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "quarantine-id2entry" -d 'Given an entry id, quarantine the entry in a hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "list-quarantined" -d 'List the entries in quarantine'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "restore-quarantined" -d 'Given an entry id, restore the entry from the hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and not __fish_seen_subcommand_from list-all-indexes list-index list-id2entry get-id2entry list-index-analysis quarantine-id2entry list-quarantined restore-quarantined help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-all-indexes" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-all-indexes" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-all-indexes" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-id2entry" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-id2entry" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-id2entry" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from get-id2entry" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from get-id2entry" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from get-id2entry" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index-analysis" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index-analysis" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-index-analysis" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from quarantine-id2entry" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from quarantine-id2entry" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from quarantine-id2entry" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-quarantined" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-quarantined" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from list-quarantined" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from restore-quarantined" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from restore-quarantined" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from restore-quarantined" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "list-all-indexes" -d 'List all index tables that exist on the system'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "list-index" -d 'List all content of a named index'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "list-id2entry" -d 'List all id2entry values with reduced entry content'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "get-id2entry" -d 'View the data of a specific entry from id2entry'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "list-index-analysis" -d 'List all content of index analysis'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "quarantine-id2entry" -d 'Given an entry id, quarantine the entry in a hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "list-quarantined" -d 'List the entries in quarantine'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "restore-quarantined" -d 'Given an entry id, restore the entry from the hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand db-scan; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "vacuum" -d 'Vacuum the database to reclaim space or change db_fs_type/page_size (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "backup" -d 'Backup the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "restore" -d 'Restore the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "verify" -d 'Verify database and entity consistency'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "reindex" -d 'Reindex the database (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and not __fish_seen_subcommand_from vacuum backup restore verify reindex help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from vacuum" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from vacuum" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from vacuum" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from backup" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from backup" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from backup" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from restore" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from restore" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from restore" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from verify" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from verify" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from reindex" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from reindex" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from reindex" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "vacuum" -d 'Vacuum the database to reclaim space or change db_fs_type/page_size (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "backup" -d 'Backup the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "restore" -d 'Restore the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify database and entity consistency'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "reindex" -d 'Reindex the database (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand database; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "show" -d 'Show the current domain'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "rename" -d 'Change the IDM domain name based on the values in the configuration'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "upgrade-check" -d 'Perform a pre-upgrade-check of this domains content. This will report possible incompatibilities that can block a successful upgrade to the next version of Kanidm. This is a safe read only operation'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "raise" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Raise the functional level of this domain to the maximum available'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "remigrate" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Rerun migrations of this domains database, optionally nominating the level to start from'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and not __fish_seen_subcommand_from show rename upgrade-check raise remigrate help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from show" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from show" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from rename" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from rename" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from rename" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from upgrade-check" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from upgrade-check" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from upgrade-check" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from raise" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from raise" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from raise" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from remigrate" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from remigrate" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from remigrate" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "show" -d 'Show the current domain'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "rename" -d 'Change the IDM domain name based on the values in the configuration'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "upgrade-check" -d 'Perform a pre-upgrade-check of this domains content. This will report possible incompatibilities that can block a successful upgrade to the next version of Kanidm. This is a safe read only operation'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "raise" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Raise the functional level of this domain to the maximum available'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "remigrate" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Rerun migrations of this domains database, optionally nominating the level to start from'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand domain; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand healthcheck" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand healthcheck" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand healthcheck" -s v -l verify-tls -d 'Disable TLS verification'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand healthcheck" -s O -l check-origin -d 'Check the \'origin\' URL from the server configuration file, instead of the \'address\''
complete -c kanidmd -n "__fish_kanidmd_using_subcommand healthcheck" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand version" -s c -l config -d 'Path to the server\'s configuration file' -r -F
complete -c kanidmd -n "__fish_kanidmd_using_subcommand version" -s o -l output -d 'Log format (still in very early development)' -r
complete -c kanidmd -n "__fish_kanidmd_using_subcommand version" -s h -l help -d 'Print help'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "server" -d 'Start the IDM Server'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "configtest" -d 'Test the IDM Server configuration, without starting network listeners'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "cert-generate" -d 'Create a self-signed ca and tls certificate in the locations listed from the configuration. These certificates should *not* be used in production, they are for testing and evaluation only!'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "recover-account" -d 'Recover an account\'s password'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "disable-account" -d 'Disable an account so that it can not be used. This can be reset with `recover-account`'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "show-replication-certificate" -d 'Display this server\'s replication certificate'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "renew-replication-certificate" -d 'Renew this server\'s replication certificate'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "refresh-replication-consumer" -d 'Refresh this servers database content with the content from a supplier. This means that all local content will be deleted and replaced with the supplier content'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "db-scan" -d 'Inspect the internal content of the database datastructures'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "database" -d 'Database maintenance, backups, restoration etc'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "domain" -d 'Change domain settings'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "healthcheck" -d 'Load the server config and check services are listening'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "version" -d 'Print the program version and exit'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and not __fish_seen_subcommand_from server configtest cert-generate recover-account disable-account show-replication-certificate renew-replication-certificate refresh-replication-consumer db-scan database domain healthcheck version help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "list-all-indexes" -d 'List all index tables that exist on the system'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "list-index" -d 'List all content of a named index'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "list-id2entry" -d 'List all id2entry values with reduced entry content'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "get-id2entry" -d 'View the data of a specific entry from id2entry'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "list-index-analysis" -d 'List all content of index analysis'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "quarantine-id2entry" -d 'Given an entry id, quarantine the entry in a hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "list-quarantined" -d 'List the entries in quarantine'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from db-scan" -f -a "restore-quarantined" -d 'Given an entry id, restore the entry from the hidden db partition'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from database" -f -a "vacuum" -d 'Vacuum the database to reclaim space or change db_fs_type/page_size (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from database" -f -a "backup" -d 'Backup the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from database" -f -a "restore" -d 'Restore the database content (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from database" -f -a "verify" -d 'Verify database and entity consistency'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from database" -f -a "reindex" -d 'Reindex the database (offline)'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from domain" -f -a "show" -d 'Show the current domain'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from domain" -f -a "rename" -d 'Change the IDM domain name based on the values in the configuration'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from domain" -f -a "upgrade-check" -d 'Perform a pre-upgrade-check of this domains content. This will report possible incompatibilities that can block a successful upgrade to the next version of Kanidm. This is a safe read only operation'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from domain" -f -a "raise" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Raise the functional level of this domain to the maximum available'
complete -c kanidmd -n "__fish_kanidmd_using_subcommand help; and __fish_seen_subcommand_from domain" -f -a "remigrate" -d '⚠️  Do not use this command unless directed by a project member. ⚠️ - Rerun migrations of this domains database, optionally nominating the level to start from'
