# Generated by Django 3.1.4 on 2020-12-02 21:43

from django.db import migrations
from django.db import models

COLOURS_OLD = {
    1: "#a6cee3",
    2: "#1f78b4",
    3: "#b2df8a",
    4: "#33a02c",
    5: "#fb9a99",
    6: "#e31a1c",
    7: "#fdbf6f",
    8: "#ff7f00",
    9: "#cab2d6",
    10: "#6a3d9a",
    11: "#b15928",
    12: "#000000",
    13: "#cccccc",
}


def forward(apps, schema_editor):
    Tag = apps.get_model("documents", "Tag")

    for tag in Tag.objects.all():
        colour_old_id = tag.colour_old
        rgb = COLOURS_OLD[colour_old_id]
        tag.color = rgb
        tag.save()


def reverse(apps, schema_editor):
    Tag = apps.get_model("documents", "Tag")

    def _get_colour_id(rdb):
        for idx, rdbx in COLOURS_OLD.items():
            if rdbx == rdb:
                return idx
        # Return colour 1 if we can't match anything
        return 1

    for tag in Tag.objects.all():
        colour_id = _get_colour_id(tag.color)
        tag.colour_old = colour_id
        tag.save()


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "1012_fix_archive_files"),
    ]

    operations = [
        migrations.RenameField(
            model_name="tag",
            old_name="colour",
            new_name="colour_old",
        ),
        migrations.AddField(
            model_name="tag",
            name="color",
            field=models.CharField(
                default="#a6cee3",
                max_length=7,
                verbose_name="color",
            ),
        ),
        migrations.RunPython(forward, reverse),
        migrations.RemoveField(
            model_name="tag",
            name="colour_old",
        ),
    ]
