import subprocess
import os

"""
This class represents the R Runtime that the user can configure
to execute external R scripts.
"""
class RRuntime:

	"""
	Read the first line of R output.

	The R command will output something like this

	R is free software and comes with ABSOLUTELY NO WARRANTY.
	You are welcome to redistribute it under certain conditions.
	Type 'license()' or 'licence()' for distribution details.

	> R.home()
	[1] "/home/user/rinstall/io/runtime/R4.2/lib/R"
	>

	In above example,
	this method would return /home/user/rinstall/io/runtime/R4.2/lib/R
	"""
	def read_r_output(self, output):
		for line in output.split('\n'):
			# Get the first line of actual output
			if line.startswith('[1]'):
				# Get everything after the [1] 
				o = line.split('[1] ')[1]
				# Return everything between the ""
				return o[1:-1]
		
		return None

	def __init__(self, binpath):
		self.binpath = binpath

	"""
	Returns the path where RevoScaleR is installed. Otherwise returns None 
	"""
	def get_revoscale_path(self):
		# try/except to prevent error where binpath is not the R executable
		try:
			p = subprocess.run([self.binpath, '-e', "system.file(package = 'RevoScaleR')"], capture_output=True, text=True)
			return self.read_r_output(p.stdout)
		except:
			return None

"""
This class represents the Python Runtime that the user can configure
to execute external Python scripts.
"""
class PythonRuntime:

	def __init__(self, binpath):
		self.binpath = binpath

	"""
	Returns the path where revoscalepy is installed. Otherwise returns None 
	"""
	def get_revoscale_path(self):
		# try/except to prevent error where binpath is not the Python executable
		try:
			args = 'from pathlib import Path;import importlib.util;print(Path(importlib.util.find_spec("revoscalepy").origin).parent)'
			p = subprocess.run([self.binpath, '-c', args], capture_output=True, text=True)
			return p.stdout
		except:
			return None