#!/bin/bash
cd /var/opt/mssql

CMDLINE="/opt/mssql/bin/sqlservr $@"

echo ""

# If running as mssql then execute the command directly. Else change user to mssql
if [ "$(id -u -n)" == "mssql" ]; then
    cd /var/opt/mssql
    /bin/bash -c "$CMDLINE"
    retcode=$?
elif [ "$(id -u)" == "0" ]; then
    # Preserve full environment.
    whitelistArg="-p"

    # RHEL9 needs to refrain from using -p because of selinux.
    if [[ `cat /etc/os-release | grep "PRETTY_NAME=\"Red Hat Enterprise Linux 9"` ]]; then
        # Build env vars whitelist with defined MSSQL_* variables.
        whitelist=$(printenv | cut -d= -f1 | grep MSSQL_ | paste -sd ",")

        if [[ -n "$whitelist" ]]; then
            whitelistArg="-w $whitelist"
        else
            whitelistArg=
        fi
    fi

    # If we are root, we can su, so lets run it as mssql
    su $whitelistArg -c "$CMDLINE" mssql
    retcode=$?
else
    echo "Please run as either root or mssql"
    retcode=1
fi

exit $retcode
