/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import com.topografix.gpx._1._0.BoundsType;
import com.topografix.gpx._1._0.Gpx;
import org.fibs.geotag.util.Util;

public final class BoundsTypeUtil {
    private BoundsTypeUtil() {
    }

    public static double pixelDistance(Gpx.Trk.Trkseg.Trkpt point1, Gpx.Trk.Trkseg.Trkpt point2, BoundsType mapBounds, int mapWidth, int mapHeight) {
        double mapLatitudeRange = mapBounds.getMaxlat().doubleValue() - mapBounds.getMinlat().doubleValue();
        double mapLongitudeRange = mapBounds.getMaxlon().doubleValue() - mapBounds.getMinlon().doubleValue();
        double pixelsPerDegreeLatitude = (double)mapHeight / mapLatitudeRange;
        double pixelsPerDegreeLongitude = (double)mapWidth / mapLongitudeRange;
        double latitudeDistance = Math.abs(point1.getLat().doubleValue() - point2.getLat().doubleValue());
        double longitudeDistance = Math.abs(point1.getLon().doubleValue() - point2.getLon().doubleValue());
        double latitudePixelDistance = latitudeDistance * pixelsPerDegreeLatitude;
        double longitudePixelDistance = longitudeDistance * pixelsPerDegreeLongitude;
        double pixelDistance = Math.sqrt(Util.square(latitudePixelDistance) + Util.square(longitudePixelDistance));
        return pixelDistance;
    }

    public static boolean intersect(BoundsType bounds1, BoundsType bounds2) {
        boolean dontIntersect = bounds1.getMinlat().compareTo(bounds2.getMaxlat()) > 0 || bounds2.getMinlat().compareTo(bounds1.getMaxlat()) > 0 || bounds1.getMinlon().compareTo(bounds2.getMaxlon()) > 0 || bounds2.getMinlon().compareTo(bounds1.getMaxlon()) > 0;
        return !dontIntersect;
    }
}

