/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.NameValue;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public class GO_GenericName
extends XmlAdapter<GO_GenericName, GenericName> {
    private GenericName name;

    public GO_GenericName() {
    }

    private GO_GenericName(GenericName genericName) {
        this.name = genericName;
    }

    @Override
    public GO_GenericName marshal(GenericName genericName) {
        return genericName != null ? new GO_GenericName(genericName) : null;
    }

    @Override
    public final GenericName unmarshal(GO_GenericName gO_GenericName) {
        return gO_GenericName != null ? gO_GenericName.name : null;
    }

    @XmlElementRef
    public final NameValue getValue() {
        NameValue nameValue;
        GenericName genericName = this.name;
        if (genericName instanceof LocalName) {
            if (genericName instanceof TypeName || genericName instanceof MemberName) {
                return null;
            }
            nameValue = FilterByVersion.LEGACY_METADATA.accept() ? new NameValue.Local() : new NameValue.Scoped();
        } else if (genericName instanceof ScopedName) {
            nameValue = new NameValue.Scoped();
        } else {
            return null;
        }
        nameValue.setName(genericName);
        return nameValue;
    }

    @XmlElementRef
    public final DefaultLocalName getName() {
        GenericName genericName = this.name;
        if (genericName instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)genericName);
        }
        if (genericName instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)genericName);
        }
        return null;
    }

    public final void setValue(NameValue nameValue) throws IllegalStateException {
        this.ensureUndefined();
        if (nameValue != null) {
            this.name = nameValue.getName();
        }
    }

    public final void setName(DefaultLocalName defaultLocalName) throws IllegalStateException {
        this.ensureUndefined();
        this.name = defaultLocalName;
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.name != null) {
            throw new IllegalStateException(Errors.format((short)164, "name"));
        }
    }

    public static final class Since2014
    extends GO_GenericName {
        @Override
        public GO_GenericName marshal(GenericName genericName) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(genericName) : null;
        }
    }
}

