/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.List;
import org.apache.solr.client.api.model.CreateAliasRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.ListAliasesResponse;
import org.apache.solr.client.api.model.RoutedAliasProperties;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class AliasesApi {

    public static class GetAliases
    extends SolrRequest<GetAliasesResponse> {
        public GetAliases() {
            super(SolrRequest.METHOD.valueOf("GET"), "/aliases");
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetAliasesResponse createResponse(SolrClient client) {
            return new GetAliasesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetAliasesResponse
    extends JacksonParsingResponse<ListAliasesResponse> {
        public GetAliasesResponse() {
            super(ListAliasesResponse.class);
        }
    }

    public static class GetAliasByName
    extends SolrRequest<GetAliasByNameResponse> {
        private final String aliasName;

        public GetAliasByName(String aliasName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/aliases/{aliasName}".replace("{aliasName}", aliasName));
            this.aliasName = aliasName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetAliasByNameResponse createResponse(SolrClient client) {
            return new GetAliasByNameResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetAliasByNameResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAliasByNameResponse> {
        public GetAliasByNameResponse() {
            super(org.apache.solr.client.api.model.GetAliasByNameResponse.class);
        }
    }

    public static class DeleteAlias
    extends SolrRequest<DeleteAliasResponse> {
        private final String aliasName;
        private String async;

        public DeleteAlias(String aliasName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/aliases/{aliasName}".replace("{aliasName}", aliasName));
            this.aliasName = aliasName;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteAliasResponse createResponse(SolrClient client) {
            return new DeleteAliasResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteAliasResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteAliasResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CreateAlias
    extends SolrRequest<CreateAliasResponse> {
        private final CreateAliasRequestBody requestBody = new CreateAliasRequestBody();

        public CreateAlias() {
            super(SolrRequest.METHOD.valueOf("POST"), "/aliases");
            this.addHeader("Content-type", "application/json");
        }

        public void setName(String name) {
            this.requestBody.name = name;
        }

        public void setCollections(List<String> collections) {
            this.requestBody.collections = collections;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setRouters(List<RoutedAliasProperties> routers) {
            this.requestBody.routers = routers;
        }

        public void setCollCreationParameters(CreateCollectionRequestBody collCreationParameters) {
            this.requestBody.collCreationParameters = collCreationParameters;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateAliasResponse createResponse(SolrClient client) {
            return new CreateAliasResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateAliasResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateAliasResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

