/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.apache.solr.api.ContainerPluginsRegistry;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.cluster.placement.PlacementPluginConfig;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.impl.DelegatingPlacementPluginFactory;
import org.apache.solr.cluster.placement.plugins.AffinityPlacementFactory;
import org.apache.solr.cluster.placement.plugins.MinimizeCoresPlacementFactory;
import org.apache.solr.cluster.placement.plugins.RandomPlacementFactory;
import org.apache.solr.cluster.placement.plugins.SimplePlacementFactory;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlacementPluginFactoryLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @VisibleForTesting
    static final String PLACEMENTPLUGIN_DEFAULT_SYSPROP = "solr.placementplugin.default";

    public static void load(final DelegatingPlacementPluginFactory pluginFactory, ContainerPluginsRegistry plugins) {
        ContainerPluginsRegistry.ApiInfo pluginFactoryInfo = plugins.getPlugin(".placement-plugin");
        if (pluginFactoryInfo != null && pluginFactoryInfo.getInstance() instanceof PlacementPluginFactory) {
            pluginFactory.setDelegate((PlacementPluginFactory)pluginFactoryInfo.getInstance());
        }
        ContainerPluginsRegistry.PluginRegistryListener pluginListener = new ContainerPluginsRegistry.PluginRegistryListener(){

            @Override
            public void added(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof PlacementPluginFactory) {
                    this.setDelegate(plugin.getInfo(), (PlacementPluginFactory)instance);
                }
            }

            @Override
            public void deleted(ContainerPluginsRegistry.ApiInfo plugin) {
                if (plugin == null || plugin.getInstance() == null) {
                    return;
                }
                Object instance = plugin.getInstance();
                if (instance instanceof PlacementPluginFactory) {
                    this.setDelegate(plugin.getInfo(), null);
                }
            }

            @Override
            public void modified(ContainerPluginsRegistry.ApiInfo old, ContainerPluginsRegistry.ApiInfo replacement) {
                this.added(replacement);
            }

            private void setDelegate(PluginMeta pluginMeta, PlacementPluginFactory<? extends PlacementPluginConfig> factory) {
                if (".placement-plugin".equals(pluginMeta.name)) {
                    pluginFactory.setDelegate(factory);
                } else {
                    log.warn("Ignoring PlacementPluginFactory plugin with non-standard name: {}", (Object)pluginMeta);
                }
            }
        };
        plugins.registerListener(pluginListener);
    }

    public static PlacementPluginFactory<?> getDefaultPlacementPluginFactory() {
        String defaultPluginId = System.getProperty(PLACEMENTPLUGIN_DEFAULT_SYSPROP);
        if (defaultPluginId != null) {
            log.info("Default replica placement plugin set in {} to {}", (Object)PLACEMENTPLUGIN_DEFAULT_SYSPROP, (Object)defaultPluginId);
            switch (defaultPluginId.toLowerCase(Locale.ROOT)) {
                case "simple": {
                    return new SimplePlacementFactory();
                }
                case "affinity": {
                    return new AffinityPlacementFactory();
                }
                case "minimizecores": {
                    return new MinimizeCoresPlacementFactory();
                }
                case "random": {
                    return new RandomPlacementFactory();
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid value for system property 'solr.placementplugin.default'. Supported values are 'simple', 'random', 'affinity' and 'minimizecores'");
        }
        return new SimplePlacementFactory();
    }
}

